
#version 430 core

layout(location = 0) out vec4 f_Bloom;

in vec2 TexCoords;

uniform sampler2D BloomInput;

uniform int horizontal;
 
uniform float weight[5] = float[] (0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);

void main()
{       

	vec3 bloomResult = texture(BloomInput, TexCoords).rgb * weight[0];

	vec2 texOffsetBloom = 2.0 / textureSize(BloomInput, 0);

   if(horizontal == 1)
   {
     for(int i = 1; i < 5; ++i)
     {

				bloomResult += (texture(BloomInput, TexCoords + vec2(texOffsetBloom.x * i, 0.0)).rgb * weight[i]);
				bloomResult += (texture(BloomInput, TexCoords - vec2(texOffsetBloom.x * i, 0.0)).rgb * weight[i]);
		 }
	 }
   else
   {
     for(int i = 1; i < 5; ++i)
     {
				bloomResult += (texture(BloomInput, TexCoords + vec2(0.0, texOffsetBloom.y * i)).rgb * weight[i]);
				bloomResult += (texture(BloomInput, TexCoords - vec2(0.0, texOffsetBloom.y * i)).rgb * weight[i]);
     }
   }

	f_Bloom.xyz = bloomResult;
	
}

